/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.get;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.actions.account.get.GetAccountRequest;
import com.floragunn.signals.actions.account.get.GetAccountResponse;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAccountAction
extends HandledTransportAction<GetAccountRequest, GetAccountResponse> {
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetAccountAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:account/get", transportService, actionFilters, GetAccountRequest::new);
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, GetAccountRequest request, final ActionListener<GetAccountResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                String scopedId = request.getAccountType() + "/" + request.getAccountId();
                ((GetRequestBuilder)this.client.prepareGet().setIndex(this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getAccounts())).setId(scopedId).execute((ActionListener)new ActionListener<GetResponse>(){

                    public void onResponse(GetResponse response) {
                        listener.onResponse((Object)new GetAccountResponse(response));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

